/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "types.h"
extern gint global_individual_count;
void makeRandIndV1(GRand *rnd, individual **myInd);
void makeRandIndV2(GRand *rnd, double wcardProb, individual **myInd,
		   GArray *garraysL[NUM_HTABLES], 
		   GArray *garraysC[NUM_HTABLES][SUBH] );
individual* makeEmptyInd();
void mutateIndV1(GRand *rnd, double mutateProb, double wcardProb, individual *myInd,
	       GArray *garraysL[NUM_HTABLES], 
	       GArray *garraysC[NUM_HTABLES][SUBH] );
guint randslot(GRand *rnd, guint numUniqueP1, double wcardProb );
void swapPop(GPtrArray **a, GPtrArray **b) ;
