/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include "service_attacks.h"


// Service list - static array

char services[10][40] = {"exec","finger","ftp","rlogin","rsh","smtp","telnet","endp"}; 

// Attack lists - static array

// This array has to match the actual strings in the bsm.list file
char attacks[END_A][255];

gint global_individual_count=0;

void init_attacks() {
  strcpy(attacks[NONE],"none");
  strcpy(attacks[GUESS_A],"guess");
  strcpy(attacks[PORT_SCAN_A],"port-scan");
  strcpy(attacks[RCP_A],"rcp");
  strcpy(attacks[RLOGIN_A],"rlogin");
  strcpy(attacks[RSH_A],"rlogin");
  strcpy(attacks[FORMAT_CLEAR_A],"format_clear");
  strcpy(attacks[FFB_CLEAR_A],"ffb_clear");
  strcpy(attacks[END_A],"end");
}



