/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SERVICE_ATTACKS_H
#define SERVICE_ATTACKS_H

#define NUM_GENE 7

enum FILE_GENE_IDX{F_DURATION=3, F_SERVICE=4, F_SOURCE_PORT=5, F_DEST_PORT=6, 
		   F_SRC_IP=7, F_DEST_IP=8, F_ATTACK=10};

enum ARY_GENE_IDX{G_DURATION=0, G_SERVICE=1, G_SOURCE_PORT=2, G_DEST_PORT=3, 
		  G_SRC_IP=4, G_DEST_IP=5, G_ATTACK=6};

enum SERVICE{EXEC=0,FINGER=1,FTP=2,RLOGIN=3,RSH=4,SMTP=5,TELNET=6,ENDP=7};

enum ATTACK{NONE=0,GUESS_A=1, PORT_SCAN_A=2, RCP_A=3, RLOGIN_A=4, RSH_A=5, 
	    FORMAT_CLEAR_A=6, FFB_CLEAR_A=7, END_A=8};

extern char services[10][40];
extern char attacks[END_A][255];

void init_attacks();
#endif
