/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "rand.h"
#include "read_bsm.h"
#include "service_attacks.h"

#include "compare.h"

#define WCARD_PROB 0.10

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif



int main() {
  GSList *auditList = NULL;
  GPtrArray *myAry, *newPop, *threeRand; // Array of individuals
  double w1 = 0.2;
  double w2 = 0.8;
  guint i,j;

  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  individual *trainer; // Random Individual
  
  guint nRecords = 0;

  char *myfile = "./bsm.list";
  //char *myfile = "./bsm_pres1.list";

  // Initialize the array
  myAry = g_ptr_array_new_with_free_func(destroyInd);
  newPop = g_ptr_array_new_with_free_func(destroyInd);
  threeRand = g_ptr_array_new_with_free_func(destroyInd);


  g_print("Audit data pulled from %s\n",myfile);


  // Load the audit list
  nRecords = build_audit_array(&auditList, myArrayL, myArrayC, myfile);

  // Build an array of training individuals now

  for (i=0; i<50000;i++) {
    makeRandIndV2(WCARD_PROB, &trainer, myArrayL, myArrayC);
    get_fitness(auditList, trainer, w1, w2, nRecords); 
    if ( trainer->fitness > 0.05 ) 
      g_ptr_array_add(myAry, trainer); 
    else
      destroyInd(trainer);
  }

  //  g_ptr_array_sort(myAry, sort_function);

  for (i=0; i < myAry->len; i++) {
    print_individual(g_ptr_array_index(myAry, i));
    trainer = g_ptr_array_index(myAry, i);
    g_print("fitness %.04f\n",trainer->fitness);
  }
  g_print("\n");

  for (i=0; i< 3 ;i++) {
    j = g_random_int_range(0, myAry->len);
    trainer = g_ptr_array_index(myAry, j);
    g_ptr_array_add(threeRand, trainer);
  }

  g_ptr_array_sort(threeRand, sort_function);

  // This will leak memory!
  // Just want to make sure we can copy part of the array 
  // g_ptr_array_free(myAry, FALSE);

  g_print("Picked 3 random individuals\n" );
  for (i=0; i< threeRand->len ;i++) {
    trainer = g_ptr_array_index(threeRand, i);
    print_individual(trainer );
    g_print("fitness %.5f\n", trainer->fitness);
  }


  return 0;

}
