/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "read_bsm.h"
#include "service_attacks.h"
#include "randslot.h"

#define WCARD_PROB 0.10

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif


gboolean compare(int *a, int *b)
{
  gboolean rvalue;
  if (*a == *b)
    rvalue = TRUE;
  else
    rvalue = FALSE;
  return rvalue;
}

void printeach(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %d count is %d\n",(char *)userdata,*(int *)a, *(int *)b);
}

void printeachchar(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %u count is %d\n",(char *)userdata, *(guchar *)a, *(guint *)b);
}

void copyeachL(gpointer a, gpointer b, gpointer userdata) {
  GArray * myArray;
  myArray = (GArray *)userdata;
  g_array_append_val( myArray, *(guint *)a);
  g_printf("Append int %d\n",*(int *)a);
}

void copyeachC(gpointer a, gpointer b, gpointer userdata) {
  GArray * myArray;
  myArray = (GArray *)userdata;
  g_array_append_val( myArray, *(guchar *)a);
  g_printf("Append int %d\n",*(guchar *)a);
  g_printf("Key is %u count is %d\n", *(guchar *)a, *(guint *)b);
}

int main() {
  GSList *auditData = NULL;
  GHashTable *myHTableL[NUM_HTABLES];
  GHashTable *myHTableC[NUM_HTABLES][SUBH];
  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  
  int nRecords = 0;
  int i,j; // loop counters
  int size; // magnitude
  gint neg1 = -1;
  guint mySlot; // random slot number picked
  guint tmpChrome[NUM_GENE]; // tempChrome created
  time_stamp myT; // temporary time stamp data
  IPAddr myIP; // temporary IP address
  individual *a;
  char *myfile = "./bsm.list";
  //char *myfile2 = "./bsm2.list";

  for (i=0; i< NUM_HTABLES;i++) 
    myHTableL[i] = g_hash_table_new_full(g_int_hash,g_int_equal, 
					(GDestroyNotify)destroyL_key,
					(GDestroyNotify)destroyL_value);

  for (i=0; i< NUM_HTABLES;i++) 
    for (j=0; j<SUBH; j++)
      myHTableC[i][j] = g_hash_table_new_full(g_char_hash,g_char_equal, 
					      (GDestroyNotify)destroyC_key,
					      (GDestroyNotify)destroyL_value);

  // Initialize each array and put wildcard at the beginning
  for (i=0; i< NUM_HTABLES;i++) {
    myArrayL[i] = g_array_new(FALSE, FALSE, sizeof(guint));
    g_array_append_val (myArrayL[i], neg1 );
  }
  
  for (i=0; i< NUM_HTABLES;i++) 
    for (j=0; j<SUBH; j++) {
      myArrayC[i][j] = g_array_new(FALSE, FALSE, sizeof(guchar));
      g_array_append_val(myArrayC[i][j], neg1 );
    }
				
  


  //nRecords = load_audit(&auditData, myfile);

  //g_printf("Read %d records\n",nRecords);


  //print the list data
  //display_list(auditData);

  //Free the list
  //g_slist_free(auditData);
  auditData = NULL;

  g_printf("Second set of audit data\n");
  nRecords = load_audit_unique(&auditData, myfile, myHTableL, myHTableC);
  g_printf("Read %d records\n",nRecords);

  display_list(auditData);

  size = g_hash_table_size(myHTableL[G_DEST_PORT]);
  g_printf("Number of unique blah is %d\n",size);

  g_hash_table_foreach(myHTableL[G_DEST_PORT], printeach, "Dest Ports list");
  g_hash_table_foreach(myHTableL[G_SOURCE_PORT], printeach, "Source Ports list");
  g_hash_table_foreach(myHTableC[G_DURATION][3], printeachchar, "Seconds");

  g_hash_table_foreach(myHTableC[G_DURATION][2], printeachchar, "Minutes");
  g_hash_table_foreach(myHTableL[G_ATTACK], printeach, "attack");
  g_hash_table_foreach(myHTableC[G_DEST_IP][2], printeachchar, "Dest IP [2]");
  g_hash_table_foreach(myHTableC[G_DEST_IP][0], printeachchar, "Dest IP [0]");

  // Load the data into arrays

  // Duration 
  // -1, Hours, Min, Sec
  //  0    1     2    3
  for (i=0; i< SUBH; i++)
    g_hash_table_foreach(myHTableC[G_DURATION][i], copyeachC, 
			 myArrayC[G_DURATION][i]);

  // Service
  g_hash_table_foreach(myHTableL[G_SERVICE], copyeachL, 
		       myArrayL[G_SERVICE]);


  // Source Port
  g_hash_table_foreach(myHTableL[G_SOURCE_PORT], copyeachL, 
		       myArrayL[G_SOURCE_PORT]);

  // Dest Port
  g_hash_table_foreach(myHTableL[G_DEST_PORT], copyeachL, 
		       myArrayL[G_DEST_PORT]);

  // Source IP Address
  // xxx, xxx, xxx, xxx
  //  0    1    2    3
  for (i=0; i< SUBH; i++)
    g_hash_table_foreach(myHTableC[G_SRC_IP][i], copyeachC, 
			 myArrayC[G_SRC_IP][i]);

  // Dest IP Address
  // xxx, xxx, xxx, xxx
  //  0    1    2    3
  for (i=0; i< SUBH; i++)
    g_hash_table_foreach(myHTableC[G_DEST_IP][i], copyeachC, 
			 myArrayC[G_DEST_IP][i]);

  // Attack
  g_hash_table_foreach(myHTableL[G_ATTACK], copyeachL, 
		       myArrayL[G_ATTACK]);
    

  // Check loaded data
  nRecords = myArrayL[G_DEST_PORT]->len;
  g_printf("The size is (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayL[G_DEST_PORT], guint, i) );

  nRecords = myArrayC[G_SRC_IP][3]->len;
  g_printf("The size is SRC_IP[3] (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayC[G_SRC_IP][3], guchar, i) );

  nRecords = myArrayC[G_DURATION][3]->len;
  g_printf("The size is G_DURATION[3] (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayC[G_DURATION][3], guchar, i) );

  // Do a sample pick
  mySlot = randslot(myArrayC[G_DURATION][3]->len, WCARD_PROB);
  g_print ("rand value of %d G_DURATION [3]\n",
	   g_array_index (myArrayC[G_DURATION][3], guchar, mySlot) );

  //  time_stamp myT; // temporary time stamp data
  // IPAddr myIP; // temporary IP address  
  myT.byte[0] = 0xff; // not used, all should be -1

  // Hours, Minutes, Seconds
  for (i=1; i<4; i++) {
    mySlot = randslot(myArrayC[G_DURATION][i]->len, WCARD_PROB);
    myT.byte[i] = g_array_index (myArrayC[G_DURATION][i], guchar, mySlot);
  }
  tmpChrome[G_DURATION] = myT.tot; // duration

  // Service
  mySlot = randslot(myArrayL[G_SERVICE]->len, WCARD_PROB);
  tmpChrome[G_SERVICE] = g_array_index (myArrayL[G_SERVICE], guint, mySlot);

  // Source Port
  mySlot = randslot(myArrayL[G_SOURCE_PORT]->len, WCARD_PROB);
  tmpChrome[G_SOURCE_PORT] = g_array_index (myArrayL[G_SOURCE_PORT], guint, mySlot);

  // Dest Port
  mySlot = randslot(myArrayL[G_DEST_PORT]->len, WCARD_PROB);
  tmpChrome[G_DEST_PORT] = g_array_index (myArrayL[G_DEST_PORT], guint, mySlot);

  // Source IP xxx.xxx.xxx.xxx
  //            0   1   2   3
  for (i=0; i<4; i++) {
    mySlot = randslot(myArrayC[G_SRC_IP][i]->len, WCARD_PROB);
    myIP.octet[i] = g_array_index (myArrayC[G_SRC_IP][i], guchar, mySlot);
  }
  tmpChrome[G_SRC_IP] = myIP.full; // source IP

  // Dest IP xxx.xxx.xxx.xxx
  //          0   1   2   3
  for (i=0; i<4; i++) {
    mySlot = randslot(myArrayC[G_DEST_IP][i]->len, WCARD_PROB);
    myIP.octet[i] = g_array_index (myArrayC[G_DEST_IP][i], guchar, mySlot);
  }
  tmpChrome[G_DEST_IP] = myIP.full; // dest IP

  // Attack. Do not select wildcard, so put its probability at 0.
  mySlot = randslot(myArrayL[G_ATTACK]->len, 0.0 );
  tmpChrome[G_ATTACK] = g_array_index (myArrayL[G_ATTACK], guint, mySlot);

  a = (individual *)g_slice_alloc0(sizeof(individual));

  // Copy the temp chromosome into the individual
  g_memmove(a->chrome, tmpChrome, 4 * NUM_GENE);
  strncpy(a->desc, 
	  "Training Chromosome", 80);

  g_printf("Random individual we just created!\n");

  print_individual(a);

  return 0;

}
